<?php
// Ubicación: public_html/asesoria.virtualex.ec/index.php

// 1. CONFIGURACIÓN DE ERRORES (Para ver si hay un error PHP oculto)
ini_set('display_errors', 1);
error_reporting(E_ALL);

// 2. AUTOLOADER
spl_autoload_register(function ($class) {
    $prefix = 'App\\';
    $base_dir = __DIR__ . '/app/';
    $len = strlen($prefix);
    if (strncmp($prefix, $class, $len) !== 0) return;
    $relative_class = substr($class, $len);
    $file = $base_dir . str_replace('\\', '/', $relative_class) . '.php';
    if (file_exists($file)) require $file;
});

// 3. DETECCIÓN DE RUTA SIMPLIFICADA
// Obtenemos solo el path de la URL
$requestUri = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);

// Eliminamos 'index.php' si está en la URL
$path = str_replace('/index.php', '', $requestUri);

// Limpiamos slashes extra
$path = '/' . trim($path, '/');

// Si la ruta está vacía o es la raíz, vamos al chat
if ($path === '/' || $path === '') {
    $path = '/chat';
}

// 4. ENRUTADOR
switch ($path) {
    case '/chat':
        $view = __DIR__ . '/app/Views/chat.php';
        if (file_exists($view)) {
            require $view;
        } else {
            // Mensaje de depuración si falla la carga de archivos
            die("<h1>Error de Estructura</h1><p>No se encuentra el archivo de vista en: <code>$view</code></p><p>Verifica que la carpeta <b>app</b> esté subida correctamente en el servidor.</p>");
        }
        break;
        
    case '/login':
        require __DIR__ . '/app/Views/login.php';
        break;

    case '/api/chat':
        header('Content-Type: application/json; charset=utf-8');
        try {
            $controller = new \App\Controllers\ChatController();
            $controller->handleRequest();
        } catch (Exception $e) {
            http_response_code(500);
            echo json_encode(['error' => 'Error Interno: ' . $e->getMessage()]);
        }
        break;

    case '/logout':
        session_start();
        session_destroy();
        header("Location: /"); 
        exit;
        break;

    default:
        // Si llegamos aquí, el .htaccess funcionó pero la ruta no coincide
        http_response_code(404);
        echo "<h1>404 Not Found (Router)</h1>";
        echo "<p>Ruta recibida por PHP: <code>" . htmlspecialchars($path) . "</code></p>";
        break;
}